<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

$json = file_get_contents('php://input');
$data = json_decode($json, true);

ini_set('display_errors', 0); // Turn off error display to avoid sending HTML as part of response

$response = ['status' => 'error', 'message' => 'Invalid input data'];

if ($data !== null) {
    // Sanitize and validate input data
    $name = filter_var($data["firstName"], FILTER_SANITIZE_STRING);
    $email = filter_var($data["email"], FILTER_VALIDATE_EMAIL);
    $phone = filter_var($data["phoneNumber"], FILTER_SANITIZE_STRING);
    $companyName = filter_var($data["companyName"], FILTER_SANITIZE_STRING);
    $message = filter_var($data["message"], FILTER_SANITIZE_STRING);

    if (!$email) {
        $response['message'] = 'Invalid email address';
        echo json_encode($response);
        exit;
    }

    require 'class/class.phpmailer.php';

    $mail = new PHPMailer;
    $mail->isSMTP();
    $mail->Host = 'server260.web-hosting.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'info@divdevelopers.com';        // SMTP username
    $mail->Password = 'kDTwkhXWkOGN'; // Your SMTP password
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;
     $mail->From = 'info@divdevelopers.com';
    $mail->FromName = 'Contact us';
    $mail->addAddress('abdulahad2212@gmail.com ', 'Contact us'); // Add a recipient
    $mail->isHTML(true);
    $mail->Subject = 'Contact us';
    $mail->Body = '
    <!DOCTYPE html>
    <!DOCTYPE html>
    <html>
    <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Contact us</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    </head>
    <body style="margin: 0; padding: 0;">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">   
            <tr>
                <td style="padding: 10px 0 30px 0;">
                    <table align="center" border="0" cellpadding="0" cellspacing="0" width="600" style="border: 1px solid #cccccc; border-collapse: collapse;">
  
                        <tr>
                            <td bgcolor="#ffffff" style="padding: 40px 30px 40px 30px;">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tr>
                                        <td style="color: #153643; font-family: Arial, sans-serif; font-size: 24px; padding-bottom: 10px; border-bottom: 1px solid #eee;">
                                            <b>Contact Form</b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding-top: 25px; color: #153643; font-family: Arial, sans-serif; font-size: 16px; line-height: 20px;">
                                            <b>Name:</b> ' . htmlspecialchars($name) . '<br>
                                            <b>Email:</b> ' . htmlspecialchars($email) . '<br>
                                            <b>Phone:</b> ' . htmlspecialchars($phone) . '<br>
                                            <b>Company Name:</b> ' . htmlspecialchars($companyName) . '<br>
                                            <b>Message:</b><br>' . nl2br(htmlspecialchars($message)) . '<br>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>'; // The email body remains unchanged

    // Send the email and return JSON response
    if ($mail->send()) {
        $response['status'] = 'success';
        $response['message'] = 'Email sent successfully';
    } else {
        $response['message'] = 'Mailer Error: ' . $mail->ErrorInfo;
    }
}

echo json_encode($response);
?>

